from django.shortcuts import render, redirect
import slugify
from inventory_app.models import *
import datetime
from django.contrib import messages
# Create your views here.

def manage_categories(request):
    categories = CategoryList.objects.all().order_by('ordering')

    if request.method == 'POST':
        category_name = request.POST.get('category_name') 
        slug = slugify.slugify(category_name)
        ordering = request.POST.get('ordering')
        status = True if request.POST.get('status') == "1" else False

        image = None
        if 'image' in request.FILES:
            image = request.FILES['image']

        new_category = CategoryList(
            name=category_name,
            slug = slug,
            ordering=ordering,
            status=status,
            image=image,
            updated = datetime.datetime.now()
        )
        new_category.save()

        return redirect('manage_categories')

    return render(request, 'settings_app/manage_categories.html', {'category_list': categories})


def edit_category(request, id):
    get_category = CategoryList.objects.get(id=id) 

    if request.method == 'POST':

        get_category.name = request.POST.get('category_name') 
        get_category.ordering = request.POST.get('ordering')
        get_category.status = True if request.POST.get('status') == "1" else False

        if 'image' in request.FILES:
            get_category.image = request.FILES['image']

        get_category.save()

        return redirect('manage_categories')
    
 
    return render(request, 'settings_app/edit_category.html', {'category': get_category})


def category_delete(request, id):
    get_category = CategoryList.objects.get(id=id) 
    if get_category:
        get_category.delete()
        messages.success(request, "Category deleted successfully!")
        return redirect('manage_categories')
    


def manage_districts(request):
    districts = DistrictList.objects.all().order_by('rank')

     
    return render(request, 'settings_app/manage_districts.html', {'district_list': districts})
