from django.utils.html import format_html
from django.contrib import admin
from . import models
 

@admin.register(models.CategoryList)
class CategoryListAdmin(admin.ModelAdmin):
    list_display = ("name", "image_tag", "ordering", "is_homepage", "status", "created")
    search_fields = ("name",)

    def image_tag(self, obj):
        if obj.image:
            return format_html('<img src="{}" width="40" height="40" style="object-fit:cover; border-radius:5px;" />', obj.image.url)
        return "No Image"
    image_tag.short_description = "Image"


@admin.register(models.BrandList)
class BrandListAdmin(admin.ModelAdmin):
    list_display = ("id", "brand_name", "ordering", "status", "created")
    list_filter = ("status",)
    search_fields = ("brand_name",)


@admin.register(models.ColorList)
class ColorListAdmin(admin.ModelAdmin):
    list_display = ("id", "color_name", "ordering", "status", "created")
    list_filter = ("status",)
    search_fields = ("color_name",)


@admin.register(models.SizeList)
class SizeListAdmin(admin.ModelAdmin):
    list_display = ("id", "size_name", "short_code", "ordering", "status", "created")
    list_filter = ("status",)
    search_fields = ("size_name", "short_code")


@admin.register(models.ProductList)
class ProductListAdmin(admin.ModelAdmin):
    list_display = (
        "name_english", "image_tag", "sku_code", "unit_price", "discount_price",
        "stock_status", "quantity", "created", "updated", "status_display"
    ) 
    search_fields = ("name_english", "sku_code")

    def status_display(self, obj):
        return not obj.deleted_status
    status_display.short_description = "Active"


    def image_tag(self, obj):
        if obj.product_image:
            return format_html('<img src="{}" width="40" height="40" style="object-fit:cover; border-radius:5px;" />', obj.product_image.url)
        return "No Image"
    image_tag.short_description = "Image"


@admin.register(models.ProductWiseColor)
class ProductWiseColorAdmin(admin.ModelAdmin):
    list_display = ("id", "product", "color",   "status", "created")
    list_filter = ("status",)
    search_fields = ("product__name_english", "color__color_name")


@admin.register(models.ProductWiseSize)
class ProductWiseSizeAdmin(admin.ModelAdmin):
    list_display = ("id", "product", "size", "status", "created")
    list_filter = ("status",)
    search_fields = ("product__name_english", "size__size_name")


@admin.register(models.ProductWiseCategory)
class ProductWiseCategoryAdmin(admin.ModelAdmin):
    list_display = ("id", "product", "category", "status", "created")
    list_filter = ("status",)
    search_fields = ("product__name_english", "category__name")


@admin.register(models.ProductImage)
class ProductImageAdmin(admin.ModelAdmin):
    list_display = ("id", "product", "image")


@admin.register(models.DistrictList)
class DistrictListAdmin(admin.ModelAdmin):
    list_display = ("id", "district_name_english", "ordering", "shipping_cost", "status", "created")
    list_filter = ("status",)
    search_fields = ("district_name_english", "district_name_bangla")


@admin.register(models.UpozillaList)
class UpozillaListAdmin(admin.ModelAdmin):
    list_display = ("id", "name", "district", "rank", "status", "created")
    list_filter = ("status", "district")
    search_fields = ("name", "district__name")


@admin.register(models.CustomerList)
class CustomerListAdmin(admin.ModelAdmin):
    list_display = ("id", "customer_name", "mobile", "email", "district", "upozilla", "status", "created")
    list_filter = ("status", "district", "upozilla")
    search_fields = ("customer_name", "mobile", "email")


@admin.register(models.CourierService)
class CourierServiceAdmin(admin.ModelAdmin):
    list_display = ("id", "courier_name", "ordering", "status")
    list_filter = ("status",)
    search_fields = ("courier_name",)


@admin.register(models.SalesOrder)
class SalesOrderAdmin(admin.ModelAdmin):
    list_display = (
        "id", "order_number", "customer", "shipping_person_name", "grand_total",
        "payment_method", "payment_status", "order_status", "order_date"
    )
    list_filter = ("payment_status", "order_status", "payment_method")
    search_fields = ("order_number", "customer__customer_name", "shipping_person_name")


@admin.register(models.SalesOrderDetails)
class SalesOrderDetailsAdmin(admin.ModelAdmin):
    list_display = ("id", "order_no", "product", "unit_price", "discount_price", "quantity", "total_price", "status")
    list_filter = ("status",)
    search_fields = ("order_no__order_number", "product__name_english")
