from django.shortcuts import render, redirect, get_object_or_404
from hr.decorators import EmployeeLogin 
from hr.models import *
from django.contrib import messages  
import datetime
import random
import string 
import json 
from django.utils import timezone
from django.db.models import Sum, Count 
from datetime import timedelta 

from django.core.mail import send_mail
from inventory_app.models import *
# Create your views here.

def employee_logn(request):
    if request.method=="POST":
        employee_id = request.POST.get('employee_id')
        password = request.POST.get('password')
        chk_data = Employee.objects.filter(
            employee_id = employee_id, password = password
        ).first()
        if chk_data:
            print("Login Success: ")
            print("Login employee_id: ", chk_data.employee_id)
            # request.session['emp_id'] = data.id
            request.session['employee_id'] = chk_data.employee_id 
            request.session['employee_name'] = chk_data.full_name
            request.session['employee_email'] = chk_data.email
            return redirect('/hr/dashboard/')
        else:
            print("Login Success") 
            return render(request, 'employee/login.html')
    return render(request, 'employee/login.html')


 
@EmployeeLogin
def employee_dashboard(request):
    customers = CustomerList.objects.all().order_by('-id')[:5]
    all_orders = SalesOrder.objects.all()
    # pending_orders = SalesOrder.objects.filter(order_status="1")
    pending_orders = 0
    total_amount = 0.0
    total_due = 0.0
    total_shipping_cost = 0.0
    if all_orders:
        for order in all_orders:
            if order.order_status == "1":
                pending_orders +=1

            if order.payment_method == "cod":
                total_due += float(order.total_amount)
                  
            total_amount += float(order.total_amount)
            total_shipping_cost += float(order.shipping_charge)


    today = timezone.now().date()

    # Last 10 Days 
    start_date = today - timedelta(days=9)

    # গত 10 দিনের order গুলো filter করা
    orders = (
        SalesOrder.objects
        .filter(order_date__date__gte=start_date, order_date__date__lte=today)
        .values('order_date__date')
        .annotate(total_amount=Sum('grand_total'), total_orders=Count('id'))
        .order_by('order_date__date')
    )

     
    bar_labels = []
    bar_data = []

     
    for i in range(10):
        day = start_date + timedelta(days=i)
        bar_labels.append(day.strftime("%d %b")) 
        order = next((o for o in orders if o['order_date__date'] == day), None)
        if order:
            bar_data.append(float(order['total_amount']))  
        else:
            bar_data.append(0)

    top_products = ProductList.objects.all().order_by('-total_sales')[:12]

    context = {
        'customers': customers,
        'bar_labels': json.dumps(bar_labels),
        'bar_data': json.dumps(bar_data),
        'pending_orders': pending_orders,
        'total_amount': total_amount,
        'total_due': total_due,
        'total_shipping_cost': total_shipping_cost,
        'top_products': top_products,
    }
    return render(request, 'common/index.html', context)



def dashboardLogout(request):  
    request.session.flush()
    return redirect('/hr/login/')


  


# @EmployeeLogin
# def access_controll_add(request):

#     return render(request, 'common/access_controll_add.html')


@EmployeeLogin
def user_access_bulk_acl(request):
    employees = Employee.objects.filter(is_delete=False)
    modules = Module.objects.prefetch_related('menus').filter(status=True).order_by('rank')
    
    context = {
        'employees': employees,
        'modules': modules,
    }
    return render(request, 'common/access_controll_add.html', context)



@EmployeeLogin
def module_menu_list(request):
    module_menus = ModuleMenu.objects.filter(status=True).order_by('module__rank','rank')
    return render(request, 'common/module_menu_list.html', {'module_menus': module_menus})



@EmployeeLogin
def module_menu_create(request):
    modules = Module.objects.filter(status=True).order_by('rank')

    if request.method == 'POST':
        module_id = request.POST.get('module')
        name = request.POST.get('name')
        rank = request.POST.get('rank') or 1
        menu_url = request.POST.get('menu_url')
        icon = request.POST.get('icon')
        color = request.POST.get('color')
        status = True if request.POST.get('status') == 'on' else False

        module = Module.objects.get(id=module_id) if module_id else None

        ModuleMenu.objects.create(
            module=module,
            name=name,
            rank=rank,
            menu_url=menu_url,
            icon=icon,
            color=color,
            status=status,
        )
        return redirect('module_menu_list')   

    return render(request, 'common/module_menu_create.html', {'modules': modules})


def department_list(request):
    departments = Department.objects.all()
    return render(request, 'employee/department_list.html', {'departments': departments})
 
# READ
@EmployeeLogin
def employee_list(request):
    employees = Employee.objects.filter(is_delete=False)
    return render(request, 'employee/employee_list.html', {'employees': employees})


# CREATE
@EmployeeLogin
def employee_create(request):
    if request.method == 'POST':
        employee = Employee(
            employee_id=request.POST['employee_id'],
            password=request.POST['password'],  # Optional: hash this
            full_name=request.POST['full_name'],
            email=request.POST['email'],
            phone=request.POST.get('phone'),
            address=request.POST.get('address'),
            department=Department.objects.get(id=request.POST['department']),
            designation=Designation.objects.get(id=request.POST['designation']),
            join_date=request.POST['join_date'],
            salary_basic=request.POST['salary_basic'],
            salary_gross=request.POST['salary_gross'],
            national_id=request.POST.get('national_id'),
            is_active=True,
            created=timezone.now()
        )
        employee.save()
        return redirect('employee_list')

    departments = Department.objects.all()
    designations = Designation.objects.all()
    return render(request, 'employee/employee_form.html', {
        'departments': departments,
        'designations': designations
    })


# UPDATE
@EmployeeLogin
def employee_update(request, id):
    employee = get_object_or_404(Employee, pk=id)
    if request.method == 'POST':
        employee.full_name = request.POST['full_name']
        employee.email = request.POST['email']
        employee.phone = request.POST.get('phone')
        employee.address = request.POST.get('address')
        employee.department = Department.objects.get(id=request.POST['department'])
        employee.designation = Designation.objects.get(id=request.POST['designation'])
        employee.join_date = request.POST['join_date']
        employee.salary_basic = request.POST['salary_basic']
        employee.salary_gross = request.POST['salary_gross']
        employee.national_id = request.POST.get('national_id')
        employee.updated = timezone.now()
        employee.save()
        return redirect('employee_list')

    departments = Department.objects.all()
    designations = Designation.objects.all()
    return render(request, 'employee/employee_form.html', {
        'employee': employee,
        'departments': departments,
        'designations': designations
    })


# DELETE (Soft Delete)
@EmployeeLogin
def employee_delete(request, id):
    employee = get_object_or_404(Employee, pk=id)
    employee.is_delete = True
    employee.save()
    return redirect('employee_list')



