from django.utils.html import format_html
from django.contrib import admin
from . import models 

 
@admin.register(models.BusinessProfile)
class BusinessProfileAdmin(admin.ModelAdmin):
    list_display = (
         "business_name", "logo_tag", "favicon_tag", "mobile", "email", "is_active", "created", "updated"
    )
    search_fields = ("business_name", "email", "mobile") 
    readonly_fields = ("created", "updated", "logo_tag", "favicon_tag")

    # Show logo thumbnail
    def logo_tag(self, obj):
        if obj.logo:
            return format_html('<img src="{}" width="40" height="40" style="object-fit:cover; border-radius:5px;" />', obj.logo.url)
        return "No Logo"
    logo_tag.short_description = "Logo"

    # Show favicon thumbnail
    def favicon_tag(self, obj):
        if obj.favicon:
            return format_html('<img src="{}" width="32" height="32" style="object-fit:cover;" />', obj.favicon.url)
        return "No Favicon"
    favicon_tag.short_description = "Favicon"




@admin.register(models.SliderList)
class SliderListAdmin(admin.ModelAdmin):
    list_display = ( "title", "image_tag", "ordering", "status", "created", "updated") 
    search_fields = ("title", "subtitle", "ordering") 

    def image_tag(self, obj):
        if obj.image:
            return format_html('<img src="{}" width="100" height="50" style="object-fit:cover;"/>', obj.image.url)
        return "No Image"
    image_tag.short_description = "Preview"

