import os
from django.core.asgi import get_asgi_application
from channels.routing import ProtocolTypeRouter, URLRouter
from channels.auth import AuthMiddlewareStack
import hr.routing

os.environ.setdefault("DJANGO_SETTINGS_MODULE", "ecom_erp.settings")

django_asgi_app = get_asgi_application()

application = ProtocolTypeRouter({
    "http": django_asgi_app,
    "websocket": AuthMiddlewareStack(
        URLRouter(hr.routing.websocket_urlpatterns)
    ),
})
