from django.urls import path
from . import views, customer_panel

urlpatterns = [
    path('', views.home, name='home'),
    path('offer-shown/', views.offer_shown, name='offer_shown'),
    path("product/<int:product_id>/<str:slug>", views.product_detail, name="product_detail"),
    path("add-to-cart/", views.add_to_cart_ajax, name="add_to_cart_ajax"),
    path('cart/', views.cart_list, name='cart_list'),
    path("cart/<int:item_id>/item-remove/", views.remove_cart_item, name="remove_cart_item"),
    path("cart/<int:item_id>/update-qty/", views.update_cart_quantity, name="update_cart_quantity"),
    path('checkout/', views.checkout, name='checkout'),
    path("order-success/<int:order_id>/", views.order_success, name="order_success"),
    path('<int:category_id>/allproducts', views.products_list, name='products_list'),
    path('filter_products', views.filter_products, name='filter_products'),
    path("search-products/", views.search_products, name="search_products"),
    path('about/', views.aboutus, name='aboutus'),
    path('contact/', views.contact_us, name='contact_us'),
    path("get-size-price/", views.get_size_price, name="get_size_price"),
    path("order-tracking/", views.order_tracking, name="order_tracking"),
    path("customer/login/", views.customer_login, name="customer_login"),
    path("customer/logout/", views.customer_logout, name="customer_logout"),
    path("customer/register/", views.customer_register, name="customer_register"),

    path('save-review/<int:product_id>/', views.save_review, name='save_review'),


    path("customer/dashboard/", views.customer_dashboard, name="customer_dashboard"),
    path("customer/update-profile/", views.customer_profile_update, name="customer_profile_update"),
    path("customer/orders/", customer_panel.customer_orders, name="customer_orders"),
    path("customer/cartlist/", customer_panel.customer_cartlist, name="customer_cartlist"),
    path("customer/wishlist/", customer_panel.customer_wishlist, name="customer_wishlist"), 
    
]
