from django.shortcuts import render, get_object_or_404, redirect 
from inventory_app.models import * 
from hr.models import * 

 
def customer_orders(request):

    customer_id = request.session.get('customer_id') 

    if not customer_id:
        return redirect('customer_login')
    
    customer = get_object_or_404(CustomerList, id=customer_id)
    print("Customer:", customer)
    order_list = SalesOrder.objects.filter(customer=customer).order_by('-order_date')


    context = {
        "order_list": order_list,
    }

     
 
    return render(request, "website/customer/customer_orders.html", context)





 
def customer_cartlist(request):
    session_key = request.session.session_key
    print("Session Key:", session_key)
    
    cart_items = AddToCart.objects.filter(session_key=session_key)
    
    context = {
        "cart_items": cart_items,
    }
 
    return render(request, "website/customer/cart_list.html", context)
 
def customer_wishlist(request):
     
 
    return render(request, "website/customer/wish_list.html")







